CREATE TRIGGER E_DDL_CREATE_DB
   ON ALL SERVER
   FOR CREATE_DATABASE
AS
BEGIN

-- Rcupration du nom de la base
DECLARE @DB_NAME sysname;
SET @DB_NAME=EVENTDATA().value('(/EVENT_INSTANCE/DatabaseName)[1]', 'sysname');

-- Teste si les fichiers JT ("type" = 0)
IF EXISTS(SELECT LEFT(physical_name, 1)
          FROM   sys.master_files
          WHERE  database_id = DB_ID(@DB_NAME)
            AND  "type" = 0
          INTERSECT --  ont des units communes 
--  avec les fichiers autres (donnes)
          SELECT LEFT(physical_name, 1)
          FROM   sys.master_files
          WHERE  database_id = DB_ID(@DB_NAME)
            AND  "type" <> 0
)
   RAISERROR('Placement des fichiers sur les disques incorrect', 16, 1);

END

--> NOTA : si le stockage des fichiers se fait sur un SAN, vous devez adapter la requte pour extraire le point de montage